#include "GetPoint.js"

function GetRect3pt( factory )
{
	var ui = moi.ui;
	var pointpicker = ui.createPointPicker();

	if ( !GetPoint( pointpicker ) )
		return false;

	ui.beginUIUpdate();
	ui.hideUI( 'FirstRectPrompt' );
	ui.showUI( 'SecondRectPrompt' );
	ui.showUI( 'WidthHeight' );
	ui.endUIUpdate();

	factory.setInput( 0, pointpicker.pt );

	ui.commandUI.g_RectFactory = factory;

	pointpicker.bindResultPt( factory.getInput(1) );
	pointpicker.bindFuncPostUpdate( ui.commandUI.OnPoint );

	for ( var i = 0; i < 2; ++i )
	{
		if ( i == 1 )
		{
			ui.beginUIUpdate();
			ui.hideUI( 'SecondRectPrompt' );
			ui.showUI( 'LastRectPrompt' );
			ui.endUIUpdate();

			pointpicker.clearBindings();
			pointpicker.bindResultPt( factory.getInput(2) );
			pointpicker.bindFuncPostUpdate( ui.commandUI.OnPoint );
			pointpicker.addSnapFunc( ui.commandUI.ThirdPointSnapFunc );
		}
	
		while ( 1 )
		{
			if ( !pointpicker.waitForEvent() )
				return false;
				
			if ( pointpicker.event == 'finished' )
			{
				break;
			}
			else if ( pointpicker.event == 'width' )
			{
				factory.setInput( 3, ui.commandUI.width.value );
				factory.update();
				ui.commandUI.g_HaveWidth = true;
			}
			else if ( pointpicker.event == 'height' )
			{
				factory.setInput( 4, ui.commandUI.height.value );
				factory.update();
				ui.commandUI.g_HaveHeight = true;
			}
		}
	}

	return true;
}
